/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*									   */
/*			Multiple Font Converter Example			   */
/*									   */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#include <stdio.h>

#include <Xm/Xm.h>

#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/DialogS.h>
#include <Xm/MessageB.h>


/*****************************************************************************/

void
button_cb
	(
	Widget		widget,
	XtPointer	clientdata,
	XtPointer	calldata
	)
{
Widget		shell, box;

shell = XtVaCreatePopupShell("shell", xmDialogShellWidgetClass, widget,
				0);

box = XtVaCreateManagedWidget("box", xmMessageBoxWidgetClass, shell,
				0);
}

/*****************************************************************************/

void
main
	(
	int		argc,
	char		**argv
	)
{
XtAppContext	app_context;
Widget		toplevel, form, button1, button2;

toplevel = XtVaAppInitialize(&app_context, argv[0],
				NULL, 0,
				&argc, argv,
				NULL,
				0);

/*
	It is important that we register our Converter after Motif
	has registered its Converter.
	This happens on VendorShell's Class Initialize.
	(so after XtVaAppInitialize())
*/

XitAddXmStringConverter(app_context);

form = XtVaCreateManagedWidget("form", xmFormWidgetClass, toplevel,
				0);

button1 = XtVaCreateManagedWidget("button1", xmPushButtonWidgetClass, form,
				0);

XtAddCallback(button1, XmNactivateCallback, button_cb, NULL);

button2 = XtVaCreateManagedWidget("button2", xmPushButtonWidgetClass, form,
				0);

XtAddCallback(button2, XmNactivateCallback, button_cb, NULL);

XtRealizeWidget(toplevel);

XtAppMainLoop(app_context);
}

/*****************************************************************************/
