/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

public class Format extends Enum {

    static final private int _ARGB32 = 0;
    static final public Format ARGB32 = new Format (_ARGB32);
    static final private int _RGB24 = 1;
    static final public Format RGB24 = new Format (_RGB24);
    static final private int _A8 = 2;
    static final public Format A8 = new Format (_A8);
    static final private int _A1 = 3;
    static final public Format A1 = new Format (_A1);
    static final private Format[] theInterned = new Format[] {
        ARGB32, RGB24, A8, A1 
    };
    static private java.util.Hashtable theInternedExtras;
    static final private Format theSacrificialOne = new Format (0);
    static public Format intern (int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        Format already = (Format) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new Format(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Format(int value) {
        value_ = value;
    }

    public boolean test (Format other) {
        return (value_ & other.value_) == other.value_;
    }
}
