package org.freedesktop.cairo;

import org.gnu.glib.Handle;

public class FontOptions extends CairoObject {

    public FontOptions() {
        super(cairo_font_options_create());
    }

    FontOptions(Handle handle) {
        super(handle);
    }

    public void setAntialias(Antialias antialias) {
        cairo_font_options_set_antialias(getHandle(), antialias.getValue());
    }

    public Antialias getAntialias() {
        return Antialias.intern(cairo_font_options_get_antialias(getHandle()));
    }

    public void setSubpixelOrder(SubpixelOrder subpixelOrder) {
        cairo_font_options_set_subpixel_order(getHandle(), subpixelOrder
                .getValue());
    }

    public SubpixelOrder getSubpixelOrder() {
        return SubpixelOrder
                .intern(cairo_font_options_get_subpixel_order(getHandle()));
    }

    public void setHintStyle(HintStyle hintStyle) {
        cairo_font_options_set_hint_style(getHandle(), hintStyle.getValue());
    }

    public HintStyle getHintStyle() {
        return HintStyle.intern(cairo_font_options_get_hint_style(getHandle()));
    }

    public void setHintMetrics(HintMetrics hintMetrics) {
        cairo_font_options_set_hint_metrics(getHandle(), hintMetrics.getValue());
    }

    public HintMetrics getHintMetrics() {
        return HintMetrics
                .intern(cairo_font_options_get_hint_metrics(getHandle()));
    }

    public void merge(FontOptions other) {
        cairo_font_options_merge(getHandle(), other.getHandle());
    }

    public boolean equal(FontOptions other) {
        return cairo_font_options_equal(getHandle(), other.getHandle());
    }

    public long hash() {
        return cairo_font_options_hash(getHandle());
    }

    protected void finalize() throws Throwable {
        cairo_font_options_destroy(getHandle());
        super.finalize();
    }

    native static final private Handle cairo_font_options_create();

    native static final private void cairo_font_options_set_antialias(
            Handle obj, int antialias);

    native static final private int cairo_font_options_get_antialias(Handle obj);

    native static final private void cairo_font_options_set_subpixel_order(
            Handle obj, int order);

    native static final private int cairo_font_options_get_subpixel_order(
            Handle obj);

    native static final private void cairo_font_options_set_hint_style(
            Handle obj, int style);

    native static final private int cairo_font_options_get_hint_style(Handle obj);

    native static final private void cairo_font_options_set_hint_metrics(
            Handle obj, int metrics);

    native static final private int cairo_font_options_get_hint_metrics(
            Handle obj);

    native static final private void cairo_font_options_destroy(Handle obj);

    native static final private void cairo_font_options_merge(Handle obj,
            Handle other);

    native static final private boolean cairo_font_options_equal(Handle obj,
            Handle other);

    native static final private long cairo_font_options_hash(Handle obj);
}
