/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Handle;

/**
 * A FontFace specifies all aspects of a font other than the size or font matrix
 * (a font matrix is used to distort a font by sheering it or scaling it
 * unequally in the two directions).
 *
 * @deprecated This class is part of the java-gnome 2.x family of libraries,
 *             which, due to their inefficiency and complexity, are no longer
 *             being maintained and have been abandoned by the java-gnome
 *             project. This class may exist in java-gnome 4.0; look out for
 *             <code>org.freedesktop.cairo.FontFace</code>.
 *             As this package was never correctly implemented in java-gnome 2.x,
 *             any new code written will likely have a considerably different
 *             public API.
 */
public class FontFace extends CairoObject {

    FontFace(Handle hndl) {
        super(hndl);
    }

    protected void finalize() throws Throwable {
        cairo_font_face_destroy(getHandle());
        super.finalize();
    }

    /*
     * Native calls
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    native static final private void cairo_font_face_destroy(Handle obj);

}
