/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gconf;

import org.gnu.glib.Boxed;

public class ConfEntry extends Boxed {
	
	public ConfEntry(String key, ConfValue value) {
		handle = gconf_entry_new_nocopy(key, value.getHandle());
	}
	
	public ConfEntry(int handle) {
		this.handle = handle;
	}
	
	public String getKey() {
		return gconf_entry_get_key(handle);
	}
	
	public ConfValue getValue() {
		int hndl = gconf_entry_get_value(handle);
		return new ConfValue(hndl);
	}
	
	public String getSchemaName() {
		return gconf_entry_get_schema_name(handle);
	}

	/****************************************
	 * BEGINNING OF NATIVE CODE
	 ****************************************/
	native static final protected int gconf_entry_new_nocopy(String key, int value);
	native static final protected String gconf_entry_get_key(int entry);
	native static final protected int gconf_entry_get_value(int entry);
	native static final protected int gconf_entry_steal_value(int entry);
	native static final protected boolean gconf_entry_get_is_default(int entry);
	native static final protected String gconf_entry_get_schema_name(int entry);
	native static final protected void gconf_entry_set_is_default(int entry, boolean isDefault);
	native static final protected void gconf_entry_set_schema_name(int entry, String schemaName);
	native static final protected void gconf_entry_set_value_nocopy(int entry, int value);
	/****************************************
	 * END OF NATIVE CODE
	 ****************************************/
}
