/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.Boxed;

/**
 * Class that can be used to play a sound.
 */
public class Sound extends Boxed 
{
	
	/**
	 * Initialize the esd connection
	 */
	public void initialize(String hostname) {
		gnome_sound_init(hostname);
	}

	/**
	 * Play the specifyed sound file.
	 * 
	 * @param filename The file to play
	 */
	static public void play(String filename) {
		gnome_sound_play(filename);
	}
	
	/**
	 * Load the sample provided
	 *
	 */
	static public int loadSample(String sampleName, String fileName) {
		return gnome_sound_sample_load(sampleName, fileName);
	}
	
	/**
	 * Shutdown the sound system.
	 */
	static public void shutdown() {
		gnome_sound_shutdown();
	}
	

    native static final protected int gnome_sound_connection_get ();
    native static final protected void gnome_sound_init (String hostname);
    native static final protected void gnome_sound_shutdown ();
    native static final protected int gnome_sound_sample_load (String sample_name, String filename);
    native static final protected void gnome_sound_play (String filename);

}

