/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:28:06 EDT
 */

package org.gnu.gnome;
import org.gnu.gdk.Color;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Type;
/**
 * A widget holding information about the overall look of the currently displayed
 * DruidPage.
 */
public class DruidPageEdge extends DruidPage {
	/**
	 * Construct a new DruidPageEdge object
	 */
	public DruidPageEdge(EdgePosition position) {
		handle = gnome_druid_page_edge_new(position.getValue());
		initializeEventHandlers();
	}
	
	/**
	 * Construct a new DruidPageEdge object
	 */
	public DruidPageEdge(EdgePosition position, boolean antialiased, String title, String text, Pixbuf logo, Pixbuf watermark, Pixbuf topWatermark) {
		handle = gnome_druid_page_edge_new_with_vals(position.getValue(), antialiased, title, text, 
				logo.getHandle(), watermark.getHandle(), topWatermark.getHandle());
		initializeEventHandlers();
	}
	
	protected void noopInit() {
	}

	/**
	 * Set the background color for the page.
	 */
	public void setBackgroundColor(Color color) {
		gnome_druid_page_edge_set_bg_color(handle, color.getHandle());
	}
	
	/**
	 * Set the color for the textbox.
	 */
	public void setTextboxColor(Color color) {
		gnome_druid_page_edge_set_textbox_color(handle, color.getHandle());
	}
	
	/**
	 * Set the background color for the logo.
	 */
	public void setLogoBackgroundColor(Color color) {
		gnome_druid_page_edge_set_logo_bg_color(handle, color.getHandle());
	}
	
	/**
	 * Set the title color.
	 */
	public void setTitleColor(Color color) {
		gnome_druid_page_edge_set_title_color(handle, color.getHandle());
	}
	
	/**
	 * Set the text color.
	 */
	public void setTextColor(Color color) {
		gnome_druid_page_edge_set_text_color(handle, color.getHandle());
	}
	
	/**
	 * Set the text to be displayed
	 */
	public void setText(String text) {
		gnome_druid_page_edge_set_text(handle, text);
	}
	
	/**
	 * Set the title to be displayed.
	 */
	public void setTitle(String title) {
		gnome_druid_page_edge_set_title(handle, title);
	}
	
	/**
	 * Set the logo for the page.
	 */
	public void setLogo(Pixbuf logo) {
		gnome_druid_page_edge_set_logo(handle, logo.getHandle());
	}
	
	/**
	 * Set the watermark for the page.
	 */
	public void setWatermark(Pixbuf watermark) {
		gnome_druid_page_edge_set_watermark(handle, watermark.getHandle());
	}
	
	/**
	 * Set the top watermark for the page.
	 */
	public void setTopWatermark(Pixbuf watermark) {
		gnome_druid_page_edge_set_top_watermark(handle, watermark.getHandle());
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_druid_page_edge_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected String getTitle(int cptr);
	native static final protected String getText(int cptr);
	native static final protected int getLogoImage(int cptr);
	native static final protected int getWatermarkImage(int cptr);
	native static final protected int getTopWatermarkImage(int cptr);
	native static final protected int getBackgroundColor(int cptr);
	native static final protected int getTextboxColor(int cptr);
	native static final protected int getLogoBackgroundColor(int cptr);
	native static final protected int getTitleColor(int cptr);
	native static final protected int getTextColor(int cptr);
	native static final protected int getPosition(int cptr);
	native static final protected int gnome_druid_page_edge_get_type();
	native static final protected int gnome_druid_page_edge_new(int position);
	native static final protected int gnome_druid_page_edge_new_with_vals(int position, boolean antialiased, String title, String text, int logo, int watermark, int topWatermark);
	native static final protected void gnome_druid_page_edge_set_bg_color(int dpe, int color);
	native static final protected void gnome_druid_page_edge_set_textbox_color(int dpe, int color);
	native static final protected void gnome_druid_page_edge_set_logo_bg_color(int dpe, int color);
	native static final protected void gnome_druid_page_edge_set_title_color(int dpe, int color);
	native static final protected void gnome_druid_page_edge_set_text_color(int dpe, int color);
	native static final protected void gnome_druid_page_edge_set_text(int dpe, String text);
	native static final protected void gnome_druid_page_edge_set_title(int dpe, String title);
	native static final protected void gnome_druid_page_edge_set_logo(int dpe, int logoImage);
	native static final protected void gnome_druid_page_edge_set_watermark(int dpe, int watermark);
	native static final protected void gnome_druid_page_edge_set_top_watermark(int dpe, int topWatermark);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
