/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

/**
 * This class implements the native methods that are used by
 * classes that implement Editable
 */
public class EditableHelper {

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final int gtk_editable_get_type();
	native static final void gtk_editable_select_region(int editable, int start, int end);
	native static final boolean gtk_editable_get_selection_bounds(int editable, int[] start, int[] end);
	native static final void gtk_editable_insert_text(int editable, String newText, int newTextLength, int[] position);
	native static final void gtk_editable_delete_text(int editable, int startPos, int endPos);
	native static final String gtk_editable_get_chars(int editable, int start, int end);
	native static final void gtk_editable_cut_clipboard(int editable);
	native static final void gtk_editable_copy_clipboard(int editable);
	native static final void gtk_editable_paste_clipboard(int editable);
	native static final void gtk_editable_delete_selection(int editable);
	native static final void gtk_editable_set_position(int editable, int position);
	native static final int gtk_editable_get_position(int editable);
	native static final void gtk_editable_set_editable(int editable, boolean isEditable);
	native static final boolean gtk_editable_get_editable(int editable);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
