/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:34 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * A Menu is a MenuShell that implements a drop down menu consisting of
 * a list of MenuItem objects which can be navigated and activated by the
 * user to perform application functions. 
 */
public class Menu extends MenuShell {
	
	/**
	 * Create a new Menu.
	 */
	public Menu() {
		noopInit();
	}
	
	protected void noopInit() {
		if (-1 == handle) {
			handle = Menu.gtk_menu_new();
			initializeEventHandlers();
		}
	}
			
	
	/**
	 * Create a new Menu from a handle to a native resource.
	 */
	public Menu(int handle) {
	    super(handle);
	}
	
	/**
	 * Move a MenuItem to a new position within the Menu.
	 * 
	 * @param child The MenuItem to be moved.
	 * @param position The new position to place the MenuItem.
	 */
	public void reorderMenuItem(MenuItem child, int position) {
		Menu.gtk_menu_reorder_child(handle, child.getHandle(), position);
	}
	
	/**
	 * Displays a menu and makes it available for selection.  Applications
	 * can use this method to provide context-sensitive menus.
	 */
	public void popup() {
		Menu.gtk_menu_popup(handle);
	}
	
	/**
	 * Detaches the menu from the widget to which it had been attached.
	 */
	public void detach() {
		Menu.gtk_menu_detach(handle);
	}
	
	/**
	 * Set the AccelGroup which holds global accelerators for the menu.
	 * The accelerator group needs to also be added to all windows that
	 * this menu is being used in.
	 * 
	 * @param accelGroup The AccelGroup to be associated with this Menu.
	 */
	public void setAccelGroup(AccelGroup accelGroup) {
		Menu.gtk_menu_set_accel_group(handle, accelGroup.getHandle());
	}
	
	/**
	 * Sets the title string for this Menu.  The title is displayed when
	 * the menu is shown as a tearoff menu.
	 * 
	 * @param title The title for the Menu.
	 */
	public void setTitle(String title) {
		Menu.gtk_menu_set_title(handle, title);
	}
	
	/**
	 * Returns the title of the menu.
	 * 
	 * @return The title for the menu.
	 */
	public String getTitle() {
		return Menu.gtk_menu_get_title(handle);
	}
	

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_menu_get_type());
	}

	native static final protected void gtk_menu_popup(int menu);
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_menu_get_type();
	native static final protected int gtk_menu_new();
	native static final protected void gtk_menu_reposition(int menu);
	native static final protected void gtk_menu_popdown(int menu);
	native static final protected int gtk_menu_get_active(int menu);
	native static final protected void gtk_menu_set_active(int menu, int index);
	native static final protected void gtk_menu_set_accel_group(int menu, int accelGroup);
	native static final protected int gtk_menu_get_accel_group(int menu);
	native static final protected void gtk_menu_set_accel_path(int menu, String accelPath);
	native static final protected void gtk_menu_detach(int menu);
	native static final protected int gtk_menu_get_attach_widget(int menu);
	native static final protected void gtk_menu_set_tearoff_state(int menu, boolean tornOff);
	native static final protected boolean gtk_menu_get_tearoff_state(int menu);
	native static final protected void gtk_menu_set_title(int menu, String title);
	native static final protected String gtk_menu_get_title(int menu);
	native static final protected void gtk_menu_reorder_child(int menu, int child, int position);
	native static final protected void gtk_menu_set_screen(int menu, int screen);
	native static final protected void gtk_menu_attach(int menu, int child, int left, int right, int top, int bottom);
	native static final protected void gtk_menu_set_monitor(int menu, int monitorNum); 
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
