/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_insert_1with_1tag (JNIEnv *env, 
        jclass cls, jint buffer, jint iter, jstring text, jstring tag) 
    {
        const char *text_g = (*env)->GetStringUTFChars(env, text, NULL);
		const char *tag_g = (*env)->GetStringUTFChars(env, tag, NULL);
		gtk_text_buffer_insert_with_tags_by_name ((GtkTextBuffer *) buffer, (GtkTextIter *)iter, text_g, -1,
							tag_g, NULL);
        (*env)->ReleaseStringUTFChars(env, text, text_g);
        (*env)->ReleaseStringUTFChars(env, tag, tag_g);
    }
	
	JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_create_1tag ( JNIEnv *env, jclass cls, jint buffer, jstring name ){
		const char *name_g = (*env)->GetStringUTFChars(env, name, NULL);
		jint retval =  (jint) gtk_text_buffer_create_tag( (GtkTextBuffer *) buffer, name_g, NULL);
        (*env)->ReleaseStringUTFChars(env, name, name_g);
		return retval;
	}
	
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1new_1noTable (JNIEnv *env, jclass 
        cls) 
    {
	return (jint)gtk_text_buffer_new (NULL);
    }

    JNIEXPORT jint JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1line_1offsetMOD (JNIEnv *env, jclass 
        cls, jint buffer, jint lineNumber, jint charOffset) 
    {
        GtkTextIter *iter_g = (GtkTextIter *) g_malloc(sizeof(GtkTextIter));
	gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*)buffer, 
						 iter_g, 
						 (gint32)lineNumber, 
						 (gint32)charOffset);
	return (jint)iter_g;
    }
    JNIEXPORT jint  JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1offsetMOD (
        JNIEnv *env, jclass cls, jint buffer, jint charOffset) 
    {
        GtkTextIter *iter_g = (GtkTextIter *) g_malloc(sizeof(GtkTextIter));
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*)buffer, 
					    iter_g, 
					    (gint32)charOffset);
	return (jint) iter_g;
    }

    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1lineMOD (
        JNIEnv *env, jclass cls, jint buffer, jint lineNumber) 
    {
        GtkTextIter *iter_g = (GtkTextIter *) g_malloc(sizeof(GtkTextIter));
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*)buffer, 
					  iter_g, 
					  (gint32)lineNumber);
	return (jint) iter_g;
    }

    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1markMOD (
        JNIEnv *env, jclass cls, jint buffer, jint mark) 
    {
        GtkTextIter *iter_g = (GtkTextIter *) g_malloc(sizeof(GtkTextIter));
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*)buffer, 
					  iter_g, 
					  (GtkTextMark*)mark);
	return (jint) iter_g;
    }
    
    JNIEXPORT jint JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1child_1anchorMOD (JNIEnv *env, 
        jclass cls, jint buffer, jint anchor) 
    {
        GtkTextIter *iter_g = (GtkTextIter *)g_malloc(sizeof(GtkTextIter));
	gtk_text_buffer_get_iter_at_child_anchor ((GtkTextBuffer*)buffer, 
						  iter_g, 
						  (GtkTextChildAnchor*)anchor);
	return (jint) iter_g;
    }

    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1start_1iterMOD (JNIEnv 
        *env, jclass cls, jint buffer) 
    {
        GtkTextIter *iter_g = (GtkTextIter *)g_malloc(sizeof(GtkTextIter));
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*)buffer, iter_g);
	return (jint) iter_g;
    }

    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1end_1iterMOD (JNIEnv 
        *env, jclass cls, jint buffer) 
    {
        GtkTextIter *iter_g = (GtkTextIter *)g_malloc(sizeof(GtkTextIter));
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*)buffer, iter_g);
	return (jint)iter_g;
    }
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1paste_1clipboardInsertPosisition (JNIEnv 
        *env, jclass cls, jint buffer, jint clipboard, jboolean 
        defaultEditable) 
    {
	gtk_text_buffer_paste_clipboard ((GtkTextBuffer*)buffer, 
					 (GtkClipboard*)clipboard, 
					 NULL, 
					 (gboolean)defaultEditable);
    }



    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1selection_1exists (JNIEnv *env, jclass cls, 
        jint buffer) 
    {
	return (jboolean)gtk_text_buffer_get_selection_bounds(
            (GtkTextBuffer*)buffer, NULL, NULL);
    }
    
    JNIEXPORT jint JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1selection_1start (JNIEnv *env, jclass cls, 
        jint buffer) 
    {
        GtkTextIter *start_g = (GtkTextIter *)g_malloc(sizeof(GtkTextIter));
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*)buffer, 
					      start_g, NULL);
	return (jint) start_g;
    }
    
    JNIEXPORT jint JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1selection_1end (JNIEnv *env, jclass cls, 
        jint buffer) 
    {
        GtkTextIter *end_g = (GtkTextIter *)g_malloc(sizeof(GtkTextIter));
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*)buffer, 
					      NULL, end_g);
	return (jint) end_g;
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1type (JNIEnv *env, 
        jclass cls) 
    {
	return (jint)gtk_text_buffer_get_type ();
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_new
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1new (JNIEnv *env, jclass 
        cls, jint table) 
    {
	return (jint)gtk_text_buffer_new ((GtkTextTagTable *)table);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_line_count
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1line_1count (JNIEnv 
        *env, jclass cls, jint buffer) 
    {
	return (jint)gtk_text_buffer_get_line_count ((GtkTextBuffer*)buffer);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_char_count
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1char_1count (JNIEnv 
        *env, jclass cls, jint buffer) 
    {
	return (jint) gtk_text_buffer_get_char_count ((GtkTextBuffer*)buffer);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_tag_table
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1tag_1table (JNIEnv 
        *env, jclass cls, jint buffer) 
    {
        return (jint)gtk_text_buffer_get_tag_table ((GtkTextBuffer*)buffer);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_set_text
     * Signature: (I[BI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1set_1text (JNIEnv *env, 
        jclass cls, jint buffer, jstring text) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, text, NULL);
	jint len = (*env)->GetStringUTFLength(env, text);
	gtk_text_buffer_set_text ((GtkTextBuffer *)buffer, 
				  (gchar*)utf, (gint32)len);
        (*env)->ReleaseStringUTFChars(env, text, utf);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_insert
     * Signature: (II[BI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1insert (JNIEnv *env, 
        jclass cls, jint buffer, jint iter, jstring text) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, text, NULL);
	jint len = (*env)->GetStringUTFLength(env, text);
	gtk_text_buffer_insert ((GtkTextBuffer*)buffer, (GtkTextIter*)iter, 
				(gchar*)utf, (gint32)len);
        (*env)->ReleaseStringUTFChars(env, text, utf);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_insert_at_cursor
     * Signature: (I[BI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1insert_1at_1cursor (
        JNIEnv *env, jclass cls, jint buffer, jstring text) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, text, NULL);
	jint len = (*env)->GetStringUTFLength(env, text);
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer *)buffer, 
					  (gchar*)utf, (gint32)len);
        (*env)->ReleaseStringUTFChars(env, text, utf);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_insert_interactive
     * Signature: (II[BIZ)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1insert_1interactive (
        JNIEnv *env, jclass cls, jint buffer, jint iter, jstring text, jboolean 
        defaultEditable) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, text, NULL);
	jint len = (*env)->GetStringUTFLength(env, text);
        gboolean defaultEditable_g = (gboolean) defaultEditable;
	jboolean result_j = 
	    (jboolean) (gtk_text_buffer_insert_interactive (
			    (GtkTextBuffer*)buffer, (GtkTextIter*)iter, 
                            (gchar*)utf, (gint32)len, defaultEditable_g));
        (*env)->ReleaseStringUTFChars(env, text, utf);
	return result_j;
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_insert_interactive_at_cursor
     * Signature: (I[BIZ)Z
     */
    JNIEXPORT jboolean JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1insert_1interactive_1at_1cursor (JNIEnv *env, 
        jclass cls, jint buffer, jstring text, jboolean defaultEditable) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, text, NULL);
	jint len = (*env)->GetStringUTFLength(env, text);
	jboolean result_j = 
	    (jboolean)(gtk_text_buffer_insert_interactive_at_cursor (
                       (GtkTextBuffer*)buffer, (gchar*)utf, 
		       (gint32)len, (gboolean)defaultEditable));
        (*env)->ReleaseStringUTFChars(env, text, utf);
	return result_j;
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_insert_range
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1insert_1range (JNIEnv 
        *env, jclass cls, jint buffer, jint iter, jint start, jint end) 
    {
	gtk_text_buffer_insert_range ((GtkTextBuffer *)buffer, 
				      (GtkTextIter *)iter, 
				      (GtkTextIter *)start, 
				      (GtkTextIter *)end);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_insert_range_interactive
     * Signature: (IIIIZ)Z
     */
    JNIEXPORT jboolean JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1insert_1range_1interactive (JNIEnv *env, jclass 
        cls, jint buffer, jint iter, jint start, jint end, jboolean defaultEditable) 
    {
	return (jboolean) gtk_text_buffer_insert_range_interactive(
                    (GtkTextBuffer*)buffer, 
		    (GtkTextIter *)iter, 
		    (GtkTextIter *)start, 
		    (GtkTextIter *)end, 
		    (gboolean)defaultEditable);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_delete
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1delete (JNIEnv *env, 
        jclass cls, jint buffer, jint start, jint end) 
    {
	gtk_text_buffer_delete ((GtkTextBuffer*)buffer, 
				(GtkTextIter *)start, 
				(GtkTextIter *)end);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_delete_interactive
     * Signature: (IIIZ)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1delete_1interactive (
        JNIEnv *env, jclass cls, jint buffer, jint start, jint end, jboolean defaultEditable) 
    {
        return (jboolean) gtk_text_buffer_delete_interactive (
                              (GtkTextBuffer*)buffer, 
			      (GtkTextIter *)start, 
			      (GtkTextIter *)end, 
			      (gboolean)defaultEditable);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_text
     * Signature: (IIIZ)[B
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1text (JNIEnv 
        *env, jclass cls, jint buffer, jint start, jint end, jboolean includeHiddenChars) 
    {
	gchar *result_g = gtk_text_buffer_get_text (
                              (GtkTextBuffer*)buffer, 
			      (GtkTextIter*)start, 
			      (GtkTextIter*)end, 
			      (gboolean)includeHiddenChars);
	return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_slice
     * Signature: (IIIZ)[B
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1slice (JNIEnv 
        *env, jclass cls, jint buffer, jint start, jint end, jboolean includeHiddenChars) 
    {
	gchar *result_g = gtk_text_buffer_get_slice (
                              (GtkTextBuffer*)buffer, 
			      (GtkTextIter*)start, 
			      (GtkTextIter*)end, 
			      (gboolean)includeHiddenChars);
	return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_insert_pixbuf
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1insert_1pixbuf (JNIEnv 
        *env, jclass cls, jint buffer, jint iter, jint pixbuf) 
    {
	gtk_text_buffer_insert_pixbuf ((GtkTextBuffer*)buffer, 
				       (GtkTextIter*)iter, 
				       (GdkPixbuf*)pixbuf);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_insert_child_anchor
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1insert_1child_1anchor (
        JNIEnv *env, jclass cls, jint buffer, jint iter, jint anchor) 
    {
	gtk_text_buffer_insert_child_anchor ((GtkTextBuffer*)buffer, 
					     (GtkTextIter*)iter, 
					     (GtkTextChildAnchor*)anchor);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_create_child_anchor
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1create_1child_1anchor (
        JNIEnv *env, jclass cls, jint buffer, jint iter) 
    {
	return (jint)gtk_text_buffer_create_child_anchor (
                         (GtkTextBuffer*)buffer, 
			 (GtkTextIter*)iter);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_create_mark
     * Signature: (I[BIZ)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1create_1mark (JNIEnv 
        *env, jclass cls, jint buffer, jstring markName, jint where, jboolean leftGravity) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, markName, NULL);
	GtkTextMark* result = gtk_text_buffer_create_mark (
                                  (GtkTextBuffer*)buffer, 
				  (gchar*)utf, 
				  (GtkTextIter*)where, 
				  (gboolean)leftGravity);
	g_assert(result != NULL);
        (*env)->ReleaseStringUTFChars(env, markName, utf);
	return (jint)result;
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_move_mark
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1move_1mark (JNIEnv *env, 
        jclass cls, jint buffer, jint mark, jint where) 
    {
	gtk_text_buffer_move_mark ((GtkTextBuffer*)buffer, 
				   (GtkTextMark*)mark, 
				   (GtkTextIter*)where);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_delete_mark
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1delete_1mark (JNIEnv 
        *env, jclass cls, jint buffer, jint mark) 
    {
	gtk_text_buffer_delete_mark ((GtkTextBuffer*)buffer, (GtkTextMark*)mark);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_mark
     * Signature: (I[B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1mark (JNIEnv *env, 
        jclass cls, jint buffer, jstring name) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, name, NULL);
	GtkTextMark *mark = gtk_text_buffer_get_mark ((GtkTextBuffer*)buffer, 
						      (gchar*)utf);
        (*env)->ReleaseStringUTFChars(env, name, utf);
	return (jint)mark;
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_move_mark_by_name
     * Signature: (I[BI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1move_1mark_1by_1name (
        JNIEnv *env, jclass cls, jint buffer, jstring name, jint where) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer *)buffer, 
					   utf, 
					   (GtkTextIter *)where);
        (*env)->ReleaseStringUTFChars(env, name, utf);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_delete_mark_by_name
     * Signature: (I[B)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1delete_1mark_1by_1name (
        JNIEnv *env, jclass cls, jint buffer, jstring name) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_text_buffer_delete_mark_by_name ((GtkTextBuffer*)buffer, utf);
        (*env)->ReleaseStringUTFChars(env, name, utf);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_insert
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1insert (JNIEnv *env, 
        jclass cls, jint buffer) 
    {
	return (jint)gtk_text_buffer_get_insert ((GtkTextBuffer*)buffer);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_selection_bound
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1selection_1bound (
        JNIEnv *env, jclass cls, jint buffer) 
    {
        return (jint)gtk_text_buffer_get_selection_bound ((GtkTextBuffer*)buffer);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_place_cursor
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1place_1cursor (JNIEnv 
        *env, jclass cls, jint buffer, jint where) 
    {
	gtk_text_buffer_place_cursor ((GtkTextBuffer*)buffer, 
				      (GtkTextIter*)where);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_apply_tag
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1apply_1tag (JNIEnv *env, 
        jclass cls, jint buffer, jint tag, jint start, jint end) 
    {
	gtk_text_buffer_apply_tag ((GtkTextBuffer*)buffer, 
				   (GtkTextTag *)tag, 
				   (GtkTextIter*)start, 
				   (GtkTextIter*)end);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_remove_tag
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1remove_1tag (JNIEnv *env, 
        jclass cls, jint buffer, jint tag, jint start, jint end) 
    {
	gtk_text_buffer_remove_tag ((GtkTextBuffer*)buffer, 
				    (GtkTextTag *)tag, 
				    (GtkTextIter*)start, 
				    (GtkTextIter*)end);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_apply_tag_by_name
     * Signature: (I[BII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1apply_1tag_1by_1name (
        JNIEnv *env, jclass cls, jint buffer, jstring name, jint start, jint end) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_text_buffer_apply_tag_by_name ((GtkTextBuffer*)buffer, 
					   utf, 
					   (GtkTextIter*)start, 
					   (GtkTextIter*)end);
        (*env)->ReleaseStringUTFChars(env, name, utf);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_remove_tag_by_name
     * Signature: (I[BII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1remove_1tag_1by_1name (
        JNIEnv *env, jclass cls, jint buffer, jstring name, jint start, jint end) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_text_buffer_remove_tag_by_name ((GtkTextBuffer*)buffer, 
					    utf, 
					    (GtkTextIter*)start, 
					    (GtkTextIter*)end);
        (*env)->ReleaseStringUTFChars(env, name, utf);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_remove_all_tags
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1remove_1all_1tags (JNIEnv 
        *env, jclass cls, jint buffer, jint start, jint end) 
    {
	gtk_text_buffer_remove_all_tags ((GtkTextBuffer*)buffer, 
					 (GtkTextIter*)start, 
					 (GtkTextIter*)end);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_iter_at_line_offset
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1line_1offset (JNIEnv *env, jclass 
        cls, jint buffer, jint iter, jint lineNumber, jint charOffset) 
    {
	gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*)buffer, 
						 (GtkTextIter*)iter, 
						 (gint32)lineNumber, 
						 (gint32)charOffset);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_iter_at_line_index
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1line_1index (JNIEnv *env, jclass 
        cls, jint buffer, jint iter, jint lineNumber, jint byteIndex) 
    {
	gtk_text_buffer_get_iter_at_line_index ((GtkTextBuffer*)buffer, 
						(GtkTextIter*)iter, 
						(gint32)lineNumber, 
						(gint32)byteIndex);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_iter_at_offset
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1offset (
        JNIEnv *env, jclass cls, jint buffer, jint iter, jint charOffset) 
    {
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*)buffer, 
					    (GtkTextIter*)iter, 
					    (gint32)charOffset);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_iter_at_line
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1line (
        JNIEnv *env, jclass cls, jint buffer, jint iter, jint lineNumber) 
    {
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*)buffer, 
					  (GtkTextIter*)iter, 
					  (gint32)lineNumber);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_start_iter
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1start_1iter (JNIEnv 
        *env, jclass cls, jint buffer, jint iter) 
    {
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*)buffer, 
					(GtkTextIter*)iter);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_end_iter
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1end_1iter (JNIEnv 
        *env, jclass cls, jint buffer, jint iter) 
    {
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*)buffer, 
				      (GtkTextIter*)iter);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_bounds
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1bounds (JNIEnv *env, 
        jclass cls, jint buffer, jint start, jint end) 
    {
	gtk_text_buffer_get_bounds ((GtkTextBuffer*)buffer, 
				    (GtkTextIter*)start, 
				    (GtkTextIter*)end);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_iter_at_mark
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1mark (
        JNIEnv *env, jclass cls, jint buffer, jint iter, jint mark) 
    {
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*)buffer, 
					  (GtkTextIter*)iter, 
					  (GtkTextMark*)mark);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_iter_at_child_anchor
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1iter_1at_1child_1anchor (JNIEnv *env, 
        jclass cls, jint buffer, jint iter, jint anchor) 
    {
	gtk_text_buffer_get_iter_at_child_anchor (
            (GtkTextBuffer*)buffer, 
	    (GtkTextIter*)iter, 
	    (GtkTextChildAnchor*)anchor);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_modified
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1modified (JNIEnv 
        *env, jclass cls, jint buffer) 
    {
	return (jboolean) gtk_text_buffer_get_modified((GtkTextBuffer*)buffer);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_set_modified
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1set_1modified (JNIEnv 
        *env, jclass cls, jint buffer, jboolean setting) 
    {
	gtk_text_buffer_set_modified ((GtkTextBuffer*)buffer, 
				      (gboolean)setting);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_add_selection_clipboard
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1add_1selection_1clipboard (
        JNIEnv *env, jclass cls, jint buffer, jint clipboard) 
    {
	gtk_text_buffer_add_selection_clipboard ((GtkTextBuffer*)buffer, 
						 (GtkClipboard*)clipboard);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_remove_selection_clipboard
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1remove_1selection_1clipboard (JNIEnv *env, 
        jclass cls, jint buffer, jint clipboard) 
    {
	gtk_text_buffer_remove_selection_clipboard ((GtkTextBuffer*)buffer, 
						    (GtkClipboard*)clipboard);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_cut_clipboard
     * Signature: (IIZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1cut_1clipboard (JNIEnv 
        *env, jclass cls, jint buffer, jint clipboard, jboolean defaultEditable) 
    {
	gtk_text_buffer_cut_clipboard ((GtkTextBuffer*)buffer, 
				       (GtkClipboard*)clipboard, 
				       (gboolean)defaultEditable);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_copy_clipboard
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1copy_1clipboard (JNIEnv 
        *env, jclass cls, jint buffer, jint clipboard) 
    {
	gtk_text_buffer_copy_clipboard ((GtkTextBuffer*)buffer, 
					(GtkClipboard*)clipboard);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_paste_clipboard
     * Signature: (IIIZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1paste_1clipboard (JNIEnv 
        *env, jclass cls, jint buffer, jint clipboard, jint overrideLocation, jboolean 
        defaultEditable) 
    {
	gtk_text_buffer_paste_clipboard ((GtkTextBuffer*)buffer, 
					 (GtkClipboard*)clipboard, 
					 (GtkTextIter*)overrideLocation, 
					 (gboolean)defaultEditable);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_get_selection_bounds
     * Signature: (III)Z
     */
    JNIEXPORT jboolean JNICALL 
    Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1get_1selection_1bounds (JNIEnv *env, jclass cls, 
        jint buffer, jint start, jint end) 
    {
	return (jboolean) gtk_text_buffer_get_selection_bounds(
                              (GtkTextBuffer*)buffer, 
			      (GtkTextIter*)start, 
			      (GtkTextIter*)end);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_delete_selection
     * Signature: (IZZ)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1delete_1selection (
        JNIEnv *env, jclass cls, jint buffer, jboolean interactive, jboolean defaultEditable) 
    {
	return (jboolean) gtk_text_buffer_delete_selection (
                              (GtkTextBuffer*)buffer, 
			      (gboolean)interactive, 
			      (gboolean)defaultEditable);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_begin_user_action
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1begin_1user_1action (
        JNIEnv *env, jclass cls, jint buffer) 
    {
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*)buffer);
    }

    /*
     * Class:     org.gnu.gtk.TextBuffer
     * Method:    gtk_text_buffer_end_user_action
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextBuffer_gtk_1text_1buffer_1end_1user_1action (JNIEnv 
        *env, jclass cls, jint buffer) 
    {
	gtk_text_buffer_end_user_action ((GtkTextBuffer*)buffer);
    }
#ifdef __cplusplus
}

#endif
