/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
  * This event is used to identify when a ToggleToolButton receives an event
 * 
 * @see ToggleToolButtonListener
 */
public class ToggleToolButtonEvent extends GtkEvent {
	
	public static class Type extends GtkEventType {
		private Type(int id, String name) {
			super(id, name);
		}

		
		public static final Type TOGGLED = new Type(1, "TOGGLED");
	}

	/**
	 * Constructor for ToggleToolButtonEvent.
	 * @param source
	 * @param type
	 */
	public ToggleToolButtonEvent(Object source, GtkEventType type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(ToggleToolButtonEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
}
