/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 * This widget is the base class for GtkHRuler and GtkVRuler. It
 * contains the configuration and calculation capability, but has no
 * ability to display the results.
 */
public class Ruler extends Widget 
{
	/**
	 * Construct a Ruler from a handle to a native resource.
	 */
	protected Ruler(Handle handle) {
	    super(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_ruler_get_type());
	}


    native static final protected int getXsrc (Handle cptr);
    native static final protected int getYsrc (Handle cptr);
    native static final protected int getSliderSize (Handle cptr);
    native static final protected double getLower (Handle cptr);
    native static final protected double getUpper (Handle cptr);
    native static final protected double getPosition (Handle cptr);
    native static final protected double getMaxSize (Handle cptr);
    native static final protected int gtk_ruler_get_type ();
    native static final protected void gtk_ruler_set_metric (Handle ruler, int metric);
    native static final protected void gtk_ruler_set_range (Handle ruler, double lower, double upper, 
        double position, double maxSize);
    native static final protected void gtk_ruler_draw_ticks (Handle ruler);
    native static final protected void gtk_ruler_draw_pos (Handle ruler);
    native static final protected int gtk_ruler_get_metric (Handle ruler);
    native static final protected void gtk_ruler_get_range (Handle ruler, double [] lower, double [] 
        upper, double [] position, double [] maxSize);

}

