/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventButton_get_type (GdkEventButton * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventButton_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventButton_get_type (obj_g));
}

GdkWindow * GdkEventButton_get_window (GdkEventButton * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventButton_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventButton_get_window (obj_g));
}

gboolean GdkEventButton_get_send_event (GdkEventButton * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventButton_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventButton_get_send_event (obj_g));
}

time_t GdkEventButton_get_time (GdkEventButton * cptr) 
{
    return cptr->time;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventButton_getTime (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return GdkEventButton_get_time (obj_g);
}

gdouble GdkEventButton_get_x (GdkEventButton * cptr) 
{
    return cptr->x;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getX
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventButton_getX (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventButton_get_x (obj_g));
}

gdouble GdkEventButton_get_y (GdkEventButton * cptr) 
{
    return cptr->y;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getY
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventButton_getY (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventButton_get_y (obj_g));
}

guint32 GdkEventButton_get_state (GdkEventButton * cptr) 
{
    return cptr->state;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getState
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventButton_getState (JNIEnv *env, jclass cls, jobject obj)
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventButton_get_state (obj_g));
}

guint32 GdkEventButton_get_button (GdkEventButton * cptr) 
{
    return cptr->button;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getButton
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventButton_getButton (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventButton_get_button (obj_g));
}

GdkDevice * GdkEventButton_get_device (GdkEventButton * cptr) 
{
    return cptr->device;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getDevice
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventButton_getDevice (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventButton_get_device (obj_g));
}

gdouble GdkEventButton_get_x_root (GdkEventButton * cptr) 
{
    return cptr->x_root;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getXRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventButton_getXRoot (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventButton_get_x_root (obj_g));
}

gdouble GdkEventButton_get_y_root (GdkEventButton * cptr) 
{
    return cptr->y_root;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getYRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventButton_getYRoot (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventButton_get_y_root (obj_g));
}


#ifdef __cplusplus
}

#endif
