/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;

import org.gnu.glib.Handle;

/**
 * The PangoAttrColor structure is used to represent attributes that are colors.
 */
public class AttrColor extends Attribute 
{

	/**
	 * Returns the color 
	 */
	public Color getColor(){
		return new Color(getColor(handle));
	}

	/****************************************
     * BEGINNING OF JNI CODE
     ****************************************/
	native static final protected Handle getColor(Handle handle);
    /****************************************
     * END OF JNI CODE
     ****************************************/
}

