/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

import org.gnu.glib.Handle;

/**
 */
public class ToggleAction extends Action {

	public ToggleAction(String name, String label, String tooltip, String stockId) {
		super(gtk_toggle_action_new(name, label, tooltip, stockId));
	}
	
	public ToggleAction(Handle handle) {
		super(handle);
	}

	public void setActive(boolean active) {
		gtk_toggle_action_set_active(getHandle(), active);
	}
	
	public boolean getActive() {
		return gtk_toggle_action_get_active(getHandle());
	}
	
	public void setDrawAsRadio(boolean drawAsRadio) {
		gtk_toggle_action_set_draw_as_radio(getHandle(), drawAsRadio);
	}
	
	public boolean getDrawAsRadio() {
		return gtk_toggle_action_get_draw_as_radio(getHandle());
	}
	
	native static final protected int gtk_toggle_action_get_type ();
	native static final protected Handle gtk_toggle_action_new(String name, String label, String tooltip, String stockId);
	native static final protected void gtk_toggle_action_toggled(Handle action);
	native static final protected void gtk_toggle_action_set_active(Handle action, boolean isActive);
	native static final protected boolean gtk_toggle_action_get_active(Handle action);
	native static final protected void gtk_toggle_action_set_draw_as_radio(Handle action, boolean radio);
	native static final protected boolean gtk_toggle_action_get_draw_as_radio(Handle action);
}
