/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.javagnome.Enum;

/**
 * 
 */
public class PreviewType extends Enum {
	static final private int _COLOR = 0;

	static final public PreviewType COLOR = new PreviewType(_COLOR);

	static final private int _GRAYSCALE = 1;

	static final public PreviewType GRAYSCALE = new PreviewType(_GRAYSCALE);


	static final private PreviewType[] theInterned = new PreviewType[] { 
		COLOR, GRAYSCALE }

	;

	static private java.util.Hashtable theInternedExtras;

	static final private PreviewType theSacrificialOne = new PreviewType(0);

	static public PreviewType intern(int value) {
		if (value < theInterned.length) {
			return theInterned[value];
		}
		theSacrificialOne.value_ = value;
		if (theInternedExtras == null) {
			theInternedExtras = new java.util.Hashtable();
		}
		PreviewType already = (PreviewType) theInternedExtras
				.get(theSacrificialOne);
		if (already == null) {
			already = new PreviewType(value);
			theInternedExtras.put(already, already);
		}
		return already;
	}

	private PreviewType(int value) {
		value_ = value;
	}

	public PreviewType or(PreviewType other) {
		return intern(value_ | other.value_);
	}

	public PreviewType and(PreviewType other) {
		return intern(value_ & other.value_);
	}

	public PreviewType xor(PreviewType other) {
		return intern(value_ ^ other.value_);
	}

	public boolean test(PreviewType other) {
		return (value_ & other.value_) == other.value_;
	}

}
