/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-09-28 10:15:52 BST
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include <jg_jnu.h>
#include "gtk_java.h"

#ifdef __cplusplus
extern "C" 
{
#endif

static jobject getTreeIter(JNIEnv* env, GtkTreeIter* iter)
{
	return getGBoxedHandle(env, iter, GTK_TYPE_TREE_ITER,
        		(GBoxedCopyFunc) gtk_tree_iter_copy,
        		(GBoxedFreeFunc) gtk_tree_iter_free);
}
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_n_columns
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1n_1columns
		(JNIEnv *env, jclass cls, jobject model) 
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    return (jint)gtk_tree_model_get_n_columns (model_g);
}
                                                                                                                            

/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_column_type
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1column_1type(JNIEnv *env, jclass cls, jobject model, jint index)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    gint index_g = (gint)index;
    return (jint)gtk_tree_model_get_column_type (model_g, index_g);
}

/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_iter
 * Signature: (II)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter
		(JNIEnv *env, jclass cls, jobject model, jobject path)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreePath *path_g = (GtkTreePath*)getPointerFromHandle(env, path);
    GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
    gboolean value = gtk_tree_model_get_iter(model_g, iter, path_g);
    if (TRUE == value)
        return getTreeIter(env, iter);
    else
        return (jobject)NULL;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_iter_from_string
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1from_1string
		(JNIEnv *env, jclass cls, jobject model, jstring path)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
    const gchar* p = (*env)->GetStringUTFChars(env, path, NULL);
    gboolean value = gtk_tree_model_get_iter_from_string(model_g, iter, p);
    (*env)->ReleaseStringUTFChars(env, path, p);
    if (TRUE == value)
        return getTreeIter(env, iter);
    else
        return (jobject)NULL;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_string_from_iter
 * Signature: (II)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1string_1from_1iter(JNIEnv *env, jclass cls, jobject model, jobject iter)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter *iter_g = (GtkTreeIter*)getPointerFromHandle(env, iter);
    return (*env)->NewStringUTF(env, gtk_tree_model_get_string_from_iter(model_g, iter_g));
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_iter_first
 * Signature: (I)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1first
		(JNIEnv *env, jclass cls, jobject model)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
    gboolean value = gtk_tree_model_get_iter_first(model_g, iter);
    if (TRUE == value)
        return getTreeIter(env, iter);
    else
        return (jobject)NULL;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_path
 * Signature: (II)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1path
		(JNIEnv *env, jclass cls, jobject model, jobject iter)
{
	GtkTreePath *path;
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter *iter_g = (GtkTreeIter*)getPointerFromHandle(env, iter);
    path = gtk_tree_model_get_path(model_g, iter_g);
    return getGBoxedHandle(env, path, GTK_TYPE_TREE_PATH, NULL,
    		(GBoxedFreeFunc) gtk_tree_path_free);
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_value
 * Signature: (III)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1value
		(JNIEnv *env, jclass cls, jobject model, jobject iter, jint column)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter *iter_g = (GtkTreeIter*)getPointerFromHandle(env, iter);
    gint column_g = (gint)column;
    GValue *value = (GValue*)g_malloc(sizeof(GValue));
    value->g_type = 0;
    gtk_tree_model_get_value(model_g, iter_g, column_g, value);
    return getStructHandle(env, value, NULL, (JGFreeFunc) g_value_unset);
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_next
 * Signature: (II)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1next
		(JNIEnv *env, jclass cls, jobject model, jobject iter)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter *iter_g = (GtkTreeIter*)getPointerFromHandle(env, iter);
    gboolean value = gtk_tree_model_iter_next(model_g, iter_g);
    if (TRUE == value)
        return getTreeIter(env, iter_g);
    else
        return (jobject)NULL;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_children
 * Signature: (II)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1children
		(JNIEnv *env, jclass cls, jobject model, jobject parent)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
    GtkTreeIter *parent_g = (GtkTreeIter*)getPointerFromHandle(env, parent);
    gboolean value = gtk_tree_model_iter_children(model_g, iter, parent_g);
    if (TRUE == value)
        return getTreeIter(env, iter);
    else
        return (jobject)NULL;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_has_child
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1has_1child(JNIEnv *env, jclass cls, jobject model, jobject iter)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter *iter_g = (GtkTreeIter*)getPointerFromHandle(env, iter);
    return (jboolean)gtk_tree_model_iter_has_child(model_g, iter_g);
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_n_children
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1n_1children(JNIEnv *env, jclass cls, jobject model, jobject iter)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter *iter_g = (GtkTreeIter*)getPointerFromHandle(env, iter);
    return (jint)gtk_tree_model_iter_n_children(model_g, iter_g);
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_nth_child
 * Signature: (III)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1nth_1child
		(JNIEnv *env, jclass cls, jobject model, jobject parent, jint n)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter *parent_g = (GtkTreeIter*)getPointerFromHandle(env, parent);
    gint n_g = (gint)n;
    GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
    gboolean value = gtk_tree_model_iter_nth_child(model_g, iter, parent_g, n_g);
    if (TRUE == value)
        return getTreeIter(env, iter);
    else
        return (jobject)NULL;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_parent
 * Signature: (II)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1parent
		(JNIEnv *env, jclass cls, jobject model, jobject child)
{
    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
    GtkTreeIter *child_g = (GtkTreeIter*)getPointerFromHandle(env, child);
    GtkTreeIter* parent = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
    gboolean value = gtk_tree_model_iter_parent(model_g, parent, child_g);
    if (TRUE == value)
        return getTreeIter(env, parent);
    else
        return (jobject)NULL;
}
                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_row_changed
// * Signature: (III)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1changed
//  (JNIEnv *env, jclass cls, jobject model, jint path, jint iter)
//{
//    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
//	gtk_tree_model_row_changed(model_g, (GtkTreePath*)path, (GtkTreeIter*)iter);
//}
//                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_row_inserted
// * Signature: (III)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1inserted
//  (JNIEnv *env, jclass cls, jobject model, jint path, jint iter)
//{
//    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
//	gtk_tree_model_row_inserted(model_g, (GtkTreePath*)path, (GtkTreeIter*)iter);
//}
//                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_row_has_child_toggled
// * Signature: (III)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1has_1child_1toggled
//  (JNIEnv *env, jclass cls, jobject model, jint path, jint iter)
//{
//    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
//	gtk_tree_model_row_has_child_toggled(model_g, (GtkTreePath*)path, (GtkTreeIter*)iter);
//}
//                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_row_deleted
// * Signature: (II)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1deleted
//  (JNIEnv *env, jclass cls, jobject model, jint path)
//{
//    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
//	gtk_tree_model_row_deleted(model_g, (GtkTreePath*)path);
//}
//                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_rows_reordered
// * Signature: (III[I)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1rows_1reordered
//  (JNIEnv *env, jclass cls, jobject model, jint path, jint iter, jintArray order)
//{
//    GtkTreeModel *model_g = (GtkTreeModel*)getPointerFromHandle(env, model);
//	gint* newOrder = (gint*)(*env)->GetIntArrayElements(env, order, NULL);
//	gtk_tree_model_rows_reordered(model_g, (GtkTreePath*)path, (GtkTreeIter*)iter, newOrder);
//}


#ifdef __cplusplus
}

#endif
